//
//  MCLocalizer.h - Adapted from PWLocalizer.h (Merlin)
//
//  Created by Frank Illenberger on 04.02.05.
//  Copyright 2005 ProjectWizards, Melle, Germany. All rights reserved.
//
//  Modified and assimilated by AJ Aug 16, 2007

#import <Cocoa/Cocoa.h>


@interface MCLocalizer : NSObject 
{
    NSString* _table;
    NSBundle* _bundle;
}

// Returns YES if the first entry in the Main Bundle's preferredLocalizations is *not* English or en.
+ (BOOL)shouldLocalize;

+ (void)localizeObjects:(NSArray*)objects table:(NSString*)table bundle:(NSBundle*)bundle;
+ (void)localizeWindow:(NSWindow*)window table:(NSString*)table bundle:(NSBundle*)bundle;
+ (void)localizeView:(NSView*)view table:(NSString*)table bundle:(NSBundle*)bundle;
+ (void)localizeMenu:(NSMenu*)menu table:(NSString *)table bundle:(NSBundle *)bundle;
+ (NSString*)localize:(NSString*)str table:(NSString*)table;
+ (NSString*)localize:(NSString*)str;

@end
